import { AppError } from "./app-error";
import { toHttpStatus } from "@shared/errors/error-ext";

describe("AppError", () => {
  const code = "41001";
  const path = "/v1/test";
  const technicalError = "something went wrong";
  const prefix = "HRR";

  it("should create AppError instance", () => {
    const error = new AppError(code, path, technicalError);

    expect(error).toBeInstanceOf(AppError);
    expect(error.code).toBe(code);
    expect(error.path).toBe(path);
    expect(error.technicalError).toBe(technicalError);
  });

  it("should convert to ErrorExt", () => {
    const error = new AppError(code, path, technicalError);

    const errorExt = error.toErrorExt(prefix);

    expect(errorExt).toBeDefined();
    expect(errorExt.code).toBe(`${prefix}${code}`);
    expect(errorExt.path).toBe(path);
    expect(errorExt.technicalError).toBe(technicalError);
  });

  it("should return correct httpStatus", () => {
    const error = new AppError(code, path);

    const status = error.httpStatus;

    expect(status).toBe(toHttpStatus(code));
  });
});
