import { ErrorExt, newErrorExt, toHttpStatus } from "@shared/errors/error-ext";

export class AppError extends Error {
  constructor(
    public readonly code: string, // e.g. "41001"
    public readonly path: string, // e.g. "/v1/poststatus-master/get-all"
    public readonly technicalError = "",
  ) {
    super(code);
  }

  toErrorExt(prefix: string): ErrorExt {
    return newErrorExt(prefix, this.code, this.path, this.technicalError);
  }

  get httpStatus(): number {
    return toHttpStatus(this.code);
  }
}
