import { toEnvelope, isAlreadyEnveloped } from "./response-envelope";

describe("response-envelope", () => {
  describe("toEnvelope", () => {
    it("should create envelope with auto-generated transactionNo", () => {
      const result = toEnvelope({ foo: "bar" });

      expect(typeof result.transactionNo).toBe("string");
      expect(result.transactionNo.length).toBeGreaterThan(0);
      expect(result.status).toBe(true);
      expect(result.data).toEqual({ foo: "bar" });
      expect(typeof result.timestamp).toBe("string");
    });

    it("should use provided transactionNo", () => {
      const result = toEnvelope({ foo: "bar" }, false, "custom-tx");

      expect(result.transactionNo).toBe("custom-tx");
      expect(result.status).toBe(false);
      expect(result.data).toEqual({ foo: "bar" });
    });
  });

  describe("isAlreadyEnveloped", () => {
    it("should return true for valid envelope", () => {
      const value = {
        transactionNo: "tx",
        timestamp: new Date().toISOString(),
        status: true,
        data: {},
      };

      expect(isAlreadyEnveloped(value)).toBe(true);
    });

    it("should return false for non-envelope value", () => {
      expect(isAlreadyEnveloped(null)).toBe(false);
      expect(isAlreadyEnveloped("string")).toBe(false);
      expect(isAlreadyEnveloped({ foo: "bar" })).toBe(false);
    });
  });
});
