import { newErrorExt, toHttpStatus } from "./error-ext";

describe("toHttpStatus", () => {
  it("should return 401 for code starting with 3", () => {
    expect(toHttpStatus("31")).toBe(401);
  });

  it("should return 400 for code starting with 4", () => {
    expect(toHttpStatus("41")).toBe(400);
  });

  it("should return 422 for code starting with 6", () => {
    expect(toHttpStatus("61")).toBe(422);
  });

  it("should return 500 for other codes", () => {
    expect(toHttpStatus("99")).toBe(500);
  });
});

describe("newErrorExt", () => {
  const prefix = "HRR";
  const path = "/v1/test";

  it("should create ErrorExt for valid error code", () => {
    // pick ONE known code only (enough for coverage)
    const code = "41001";

    const result = newErrorExt(prefix, code, path, "technical error");

    expect(result.code).toBe(`${prefix}${code}`);
    expect(result.path).toBe(path);
    expect(result.technicalError).toBe("technical error");

    // important: mapping values exist
    expect(result.message).toBeDefined();
    expect(result.description).toBeDefined();
    expect(result.type).toBeDefined();
  });

  it("should throw error when error code not found", () => {
    expect(() => newErrorExt(prefix, "99999", path)).toThrow(
      "not found error code",
    );
  });
});
