import {
  CallHandler,
  ExecutionContext,
  Injectable,
  NestInterceptor,
} from "@nestjs/common";
import { Reflector } from "@nestjs/core";
import { Observable, map } from "rxjs";
import { isAlreadyEnveloped, toEnvelope } from "@shared/http/response-envelope";
import { SKIP_ENVELOPE_KEY } from "@shared/http/skip-envelope.decorator";

@Injectable()
export class ResponseEnvelopeInterceptor implements NestInterceptor {
  constructor(private readonly reflector: Reflector) {}

  intercept(ctx: ExecutionContext, next: CallHandler): Observable<any> {
    const skip = this.reflector.getAllAndOverride<boolean>(SKIP_ENVELOPE_KEY, [
      ctx.getHandler(),
      ctx.getClass(),
    ]);
    if (skip) return next.handle();

    return next
      .handle()
      .pipe(
        map((data) =>
          isAlreadyEnveloped(data) ? data : toEnvelope(data, true),
        ),
      );
  }
}
