import { randomUUID } from "node:crypto";

export type ResponseEnvelope<T = unknown> = {
  transactionNo: string;
  timestamp: string;
  status: boolean;
  data: T;
};

export function toEnvelope<T>(
  data: T,
  status = true,
  tx?: string,
): ResponseEnvelope<T> {
  return {
    transactionNo: tx ?? randomUUID(),
    timestamp: new Date().toISOString(),
    status,
    data,
  };
}

export function isAlreadyEnveloped(value: any): value is ResponseEnvelope {
  return (
    !!value &&
    typeof value === "object" &&
    "transactionNo" in value &&
    "timestamp" in value &&
    "status" in value &&
    "data" in value
  );
}
