import "reflect-metadata";
import { SKIP_ENVELOPE_KEY, SkipEnvelope } from "./skip-envelope.decorator";

describe("SkipEnvelope decorator", () => {
  it("should set skip envelope metadata to true", () => {
    class TestController {
      @SkipEnvelope()
      handler(): void {
        return;
      }
    }

    const descriptor = Object.getOwnPropertyDescriptor(
      TestController.prototype,
      "handler",
    );

    // Convert from any -> unknown first
    const handlerValue: unknown = descriptor?.value;

    // Type guard to ensure correct target
    if (typeof handlerValue !== "function") {
      throw new TypeError("Handler method not found or is not a function");
    }

    const metadata: boolean | undefined = Reflect.getMetadata(
      SKIP_ENVELOPE_KEY,
      handlerValue,
    ) as boolean | undefined;

    expect(metadata).toBe(true);
  });
});
